clear all;
close all;

%set the figure counter to one
hh = 1;


%This section of this file plots the seroprevalence data used in Figure 1 for the overall
%population and for the population 65 and over.

%LOAD SEROPREVALENCE DATA

sdate = [43876.00	44027.00	44055.00	44088.00	44117.00	44148.00	44178.00	44210.00	44240.00	44270.00	44300.00	44330.00	44361.00	44393.00	44419.00	44454.00	44481.00	44511.00	44541.00	44650.00	44742.00	44834.00	44926.00];
sdate = sdate - sdate(1);
sdatelabel = datetime('15-Feb-2020')+days(sdate);
sdatecl = [43876.00	44056.00	44070.00	44084.00	44098.00	44112.00	44126.00	44150.00	44164.00	44177.00	44248.00	44262.00	44276.00	44290.00	44304.00	44318.00	44332.00	44346.00	44360.00	44374.00	44388.00	44472.00	44500.00	44528.00	44556.00	44590.00	44618.00];
sdatecl = sdatecl - sdatecl(1);
sdatelabelcl = datetime('15-Feb-2020')+days(sdatecl);
cprevalence = [0	0.037	0.048	0.05	0.059	0.082	0.119	0.205	0.335	0.492	0.714	0.833	0.874	0.888	0.896	0.918	0.929	0.939	0.947	0.922	0.9431	0.9599	0.9671];
cprevalence65 = [0 0.015	0.027	0.025	0.03	0.04	0.063	0.119	0.38	0.728	0.891	0.922	0.93	0.944	0.943	0.952	0.955	0.958	0.963	0.8846	0.9046	0.9305	0.9252];
iprevalence = [0	0.035	0.047	0.049	0.057	0.079	0.115	0.159	0.184	0.198	0.207	0.202	0.206	0.202	0.219	0.245	0.262	0.278	0.288	0.4876	0.5871	0.7019	0.7754];
iprevalence65 = [0 0.013	0.025	0.023	0.028	0.038	0.061	0.091	0.115	0.109	0.117	0.117	0.119	0.122	0.128	0.146	0.16	0.166	0.167	0.2598	0.3256	0.4661	0.5646];
iprevalencecl = [0 0.059	0.062	0.064	0.068	0.068	0.072	0.08	0.094	0.115	0.2	0.208	0.204	0.207	0.218	0.214	0.221	0.215	0.216	0.211	0.206	0.292	0.307	0.316	0.335	0.433	0.577];
iprevalencecl65 = [0 0.025	0.034	0.033	0.031	0.036	0.039	0.039	0.054	0.063	0.124	0.132	0.134	0.131	0.13	0.136	0.124	0.127	0.124	0.126	0.128	0.163	0.171	0.175	0.191	0.233	0.332];

%PLOT SEROPREVALENCE DATA OVERALL AND OVER 65

figure(hh)

plot(sdatelabel,cprevalence,'o',sdatelabel,iprevalence,'+',sdatelabelcl,iprevalencecl,'*','LineWidth',2)
%title('The time path of Combined and Infection Seroprevalence')
%xlabel('date')
h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
exportgraphics(gcf,'Figure1.pdf','ContentType','vector')


hh = hh+1;

%uncomment these lines to make Excel files
%writematrix(sdatelabel,'Figure1.xls');
%writematrix(cprevalence,'Figure1.xls','WriteMode','append');
%writematrix(iprevalence,'Figure1.xls','WriteMode','append');
%writematrix(sdatelabelcl,'Figure1.xls','WriteMode','append');
%writematrix(iprevalencecl,'Figure1.xls','WriteMode','append');

figure(hh)

plot(sdatelabel,cprevalence,'o',sdatelabel,iprevalence,'+',sdatelabelcl,iprevalencecl,'*','LineWidth',2)
title('The time path of Combined and Infection Seroprevalence')
xlabel('date')
h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
exportgraphics(gcf,'FigureA1Left.pdf','ContentType','vector')

hh = hh+1;

figure(hh)

plot(sdatelabel,cprevalence65,'o',sdatelabel,iprevalence65,'+',sdatelabelcl,iprevalencecl65,'*','LineWidth',2)
title('The time path of Combined and Infection Seroprevalence for 65+')
xlabel('date')
h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
exportgraphics(gcf,'FigureA1Right.pdf','ContentType','vector')

hh = hh+1;

%Now enter the data on death rates by vaccination status

deathbyvaxstatus = [44290	0.00000386872737439274	0.00001901506127036610	0.203455951
44297	0.00000402918519790272	0.00001947328226127170	0.206908375
44304	0.00000366584226626116	0.00001886122414560410	0.194358661
44311	0.00000337313604431630	0.00001689716176262990	0.199627375
44318	0.00000240423862555492	0.00001592200527625280	0.151000994
44325	0.00000188377880759889	0.00001350271666646490	0.139511096
44332	0.00000190926664371591	0.00001185492627385120	0.161052595
44339	0.00000141599339580680	0.00001039161656392280	0.136263053
44346	0.00000125940983374429	0.00000839983996624896	0.149932599
44353	0.00000106965390878443	0.00000818428784003397	0.130696028
44360	0.00000129461050040749	0.00000833004015327004	0.155414677
44367	0.00000147697585419360	0.00000944096018086607	0.156443394
44374	0.00000154677750561590	0.00001214681634199330	0.127340157
44381	0.00000263660120580496	0.00001838426862184350	0.14341616
44388	0.00000457118470127888	0.00002810752340172080	0.16263207
44395	0.00000742453675047271	0.00004875733366548940	0.152275282
44402	0.00001136640388070000	0.00007423526789347990	0.15311326
44409	0.00001500001211035890	0.00009994966232310570	0.150075666
44416	0.00001774801479747220	0.00011921513441703900	0.14887384
44423	0.00001871361972565230	0.00012935400195457800	0.144669816
44430	0.00001769845852594850	0.00012712756272356100	0.139218106
44437	0.00001660154598444290	0.00012465913477413900	0.133175527
44444	0.00001531133876942350	0.00011186558351830500	0.136872649
44451	0.00001382912361526560	0.00009852870870293590	0.140356286
44458	0.00001164494245025470	0.00008147570308121800	0.142925339
44465	0.00000994640335113818	0.00006895933766082140	0.144235773
44472	0.00000859830869307427	0.00006112733801234100	0.140662247
44479	0.00000810521362350512	0.00005625883670001840	0.144070054
44486	0.00000764654679613635	0.00005130149270999540	0.149051156
44493	0.00000731170217225606	0.00004843786583230200	0.150950131
44500	0.00000786334696281646	0.00005144859399374310	0.152838909
44507	0.00000828168696522356	0.00005488983529307730	0.150878335
44514	0.00000906242861579837	0.00006435134143846210	0.140827346
44521	0.00000907662028302807	0.00006383779744438850	0.142182541
44528	0.00001025273749639250	0.00008106934853957810	0.126468729
44535	0.00000968549700953612	0.00006291711711142640	0.153940572
44542	0.00000872178645162648	0.00005808040367777770	0.150167456
44549	0.00001101294202890050	0.00006102649635282240	0.180461647
44556	0.00002654389859615210	0.00009158869017514750	0.289816336
44563	0.00004046981049161200	0.00012759573087776400	0.317172136
44570	0.00004110427034828060	0.00012919801297749500	0.3181494
44577	0.00003760951634223660	0.00011943927762545800	0.31488399
44584	0.00002907160246810800	0.00010161449740182200	0.286096996
44591	0.00002018920554393200	0.00007270232251475510	0.277696844
44598	0.00001381251355156280	0.00005299960515564110	0.260615405
44605	0.00000910900366564729	0.00003349696379733840	0.271935203
44612	0.00000587958583417306	0.00002307435892511790	0.254810366
44619	0.00000446467409952113	0.00001570053122582520	0.284364525
44626	0.00000291036650989620	0.00001048514456715900	0.27757047
44633	0.00000224953102255177	0.00000725680384749240	0.309989228
44640	0.00000164994358337145	0.00000563437772495547	0.292835103
44647	0.00000162579029155775	0.00000403507216670321	0.402914799
44654	0.00000168788158957367	0.00000387984427084796	0.435038489
44661	0.00000189278050282260	0.00000400416068969280	0.472703433
44668	0.00000249577882331626	0.00000356549125105762	0.699981755
44675	0.00000308277234746697	0.00000494901306574450	0.622906488
44682	0.00000368999703421287	0.00000575438283606384	0.641249833
44689	0.00000459417730467741	0.00000720737114077340	0.637427602
44696	0.00000504261611511293	0.00000785369356533569	0.642069375
44703	0.00000557542203861133	0.00000901661426453943	0.618349846
44710	0.00000587340423954369	0.00000958928837673624	0.612496361
44717	0.00000661583357249495	0.00000961396185488806	0.688148515
44724	0.00000668047899010349	0.00001051819035381780	0.635135776
44731	0.00000688575174219811	0.00001100286720989910	0.625814309
44738	0.00000754929528313606	0.00001310554173634550	0.576038399
44745	0.00000806442300306568	0.00001336174613851340	0.603545593
44752	0.00000881832045810396	0.00001420777014115070	0.620668857
44759	0.00000872805820980160	0.00001470969092083680	0.59335429
44766	0.00000790571610368064	0.00001369703305468170	0.577184568
44773	0.00000746275145142960	0.00001326173971141210	0.562727939
44780	0.00000651671892597657	0.00001278417966393470	0.509748697
44787	0.00000564970897790042	0.00001054065011642040	0.535992459
44794	0.00000451101303258948	0.00000873787218727808	0.516259901
44801	0.00000422113705251099	0.00000780919371608270	0.540534299];

deathratedates = datetime(deathbyvaxstatus(:,1),'ConvertFrom','excel');

figure(hh)

plot(deathratedates,deathbyvaxstatus(:,2),'--',deathratedates,deathbyvaxstatus(:,3),'LineWidth',2)
%title('COVID Mortality by Vaccination Status')
%xlabel('date')
h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
exportgraphics(gcf,'Figure3Left.pdf','ContentType','vector')

hh = hh+1;

%uncomment these lines to produce an Excel File
%writematrix(transpose(deathratedates),'Figure3Left.xls');
%writematrix(transpose(deathbyvaxstatus(:,2)),'Figure3Left.xls','WriteMode','append');
%writematrix(transpose(deathbyvaxstatus(:,3)),'Figure3Left.xls','WriteMode','append');

figure(hh)

plot(deathratedates,deathbyvaxstatus(:,4),'LineWidth',2)
%title('Ratio of COVID Mortality by Vaccination Status')
ylim([0,1])
%xlabel('date')
h=gcf;
set(h,'PaperOrientation','landscape');
set(h,'PaperUnits','normalized');
set(h,'PaperPosition', [0 0 1 1]);
exportgraphics(gcf,'Figure3Right.pdf','ContentType','vector')

hh = hh+1;

%uncomment these lines to make an Excel File
%writematrix(transpose(deathratedates),'Figure3Right.xls');
%writematrix(transpose(deathbyvaxstatus(:,4)),'Figure3Right.xls','WriteMode','append');



